Option Explicit

Main
Wscript.Quit 0

Sub Main()
	' dim variables
	' constants
	Const ForReading = 1
	Const TristateFalse = 0
	Const ChunkSize = 2000000
	' filesystem, file, textstreams
	Dim fs
	Dim filBody
	Dim filLog
	Dim tsRead
	Dim tsWrite
	Dim tsLog
	' arrays, strings, counter
	Dim strChunk, strRead, strRaw, strId
	dim arrParsed 
	Dim lngNum, lngAllCur
	
	' set variables
	Set fs = CreateObject("Scripting.FileSystemObject")
	Set filBody = fs.GetFile("CSVs\Attachment.Body.csv")
	Set filLog = fs.GetFile("log.txt")
	Set tsRead = filBody.OpenAsTextStream(ForReading, TristateFalse)
	Set tsLog = filLog.OpenAsTextStream(8, TristateFalse) ' 8 = ForAppending
	
	' create export folder
	On Error Resume Next
	fs.CreateFolder("Exported Attachments")
	On Error Goto 0
	
	' skip first line
	tsRead.SkipLine

	' this procedure--written by Michael Fitzgerald--reads strChunk from filBody
	' and recursively builds strRaw, a raw string of characters to be parsed into
	' the array arrParsed, which provides the info for building files.
	strChunk = ""
	strRaw = ""
	' Iterate until EOF
	Do While Not tsRead.AtEndOfStream
		' populate strChunk variable based on size allocation set above
		strChunk = tsRead.Read(ChunkSize)
		' append strChunk to strRaw to build the string to write to the file
		strRaw = strRaw & strChunk 
		' do until there are no carriage returns/line feeds within the line
		Do Until InStr(strRaw, vbCrLf) = 0 
			' parse array into 3 parts: (1) ID, (2) comma (not used), (3) body
			arrParsed = Split(Mid(strRaw, 1, InStr(strRaw, vbCrLf)), """") 
			
			strId = arrParsed(1) ' grab recordid
			' create the file
			Set tsWrite = fs.CreateTextFile("Exported Attachments\" & strId & ".base64")
			'  write the body
			tsWrite.WriteLine arrParsed(3) 
			' close the file
			tsWrite.Close
			Status tsLog, "  Creating Attachment file #" & lngNum + 1
			' clear variable
			Set tsWrite = Nothing 
				
			' alter the line to equal what is left after the last vbCrLf if there is anything
			strRaw = Mid(strRaw, InStr(strRaw, vbCrLf) + 1)
			
			lngNum = lngNum + 1
		Loop
	Loop
	tsLog.Close
	
	' clear variables
	Set tsRead = Nothing
	Set tsWrite = Nothing
	Set tsLog = Nothing
End Sub

Sub Status (tsLog, strMessage)
	' If the program was run with CSCRIPT, this writes a
	' line into the DOS box. If run with WSCRIPT, it does nothing.
	Dim ts ' As Scripting.TextStream
	Dim fs ' As Scripting.FileSystemObject
	Const ForAppending = 8 ' Scripting.IOMode
	If Lcase(Right(Wscript.FullName, 12)) = "\cscript.exe" Then 
		Wscript.Echo strMessage
		tsLog.WriteLine strMessage
	End If
End Sub