@ECHO off

:: set Data Loader Directory
SET DLDir=C:\Program Files\salesforce.com\Apex Data Loader 17.0
SET SaveLog=n

:: display disclaimers
CLS
ECHO +-------------------- FILEEXPORTER: COPYRIGHT NOTICE --------------------+
ECHO ^|                   Copyright (C) Ezra Kenigsberg 2012                   ^|
ECHO ^| Permission is hereby granted, free of charge, to any person obtaining  ^|
ECHO ^| a copy of this software and associated documentation files (the        ^|
ECHO ^| "Software"), to deal in the Software without restriction, including    ^|
ECHO ^| without limitation the rights to use, copy, modify, merge, publish,    ^|
ECHO ^| distribute, sublicense, and/or sell copies of the Software, and to     ^|
ECHO ^| permit persons to whom the Software is furnished to do so, subject to  ^|
ECHO ^| the following conditions:                                              ^|
ECHO ^|                                                                        ^|
ECHO ^| The above copyright notice and this permission notice shall be         ^|
ECHO ^| included in all copies or substantial portions of the Software.        ^|
ECHO ^|                                                                        ^|
ECHO ^| THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        ^|
ECHO ^| EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     ^|
ECHO ^| MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ^|
ECHO ^| IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   ^|
ECHO ^| CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   ^|
ECHO ^| TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      ^|
ECHO ^| SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 ^|
ECHO +------------------------------------------------------------------------+

:: write config.properties
ECHO #Loader Config > config.properties

:: delete previous log
DEL log.txt > NUL 2>&1

:: create CSVs directory
MD CSVs > NUL 2>&1

:: prompt user for Data Loader directory
ECHO.
ECHO SET DATA LOADER DIRECTORY
ECHO - FileExporter works best with Data Loader 17.
ECHO - The default Data Loader location is
ECHO   "%DLDir%"
SET /P DLDir=- Set Data Loader directory (press enter for default): 

:: store current directory
SET WorkDir=%CD%

:: create process-conf.xml
CALL Step1-GenerateXML.bat "%DLDir%"

:menu
	:: show Extract Menu
	ECHO.
	ECHO MAIN MENU
	ECHO - What do you want to do: 
	ECHO - (a) Extract Attachments
	ECHO - (c) Extract Content
	ECHO - (d) Extract Documents
	ECHO - (q) Quit

	:: prompt user for Main Menu option
	ECHO.
	SET Option=q
	SET /P Option=- Enter your menu option: 
	IF %Option%==a GOTO attachments
	IF %Option%==c GOTO content
	IF %Option%==d GOTO documents
	GOTO quit

:attachments
	:: grab Salesforce data
	ECHO.
	ECHO EXTRACTING ATTACHMENT BODIES...
	ECHO EXTRACTING ATTACHMENT BODIES     >> log.txt
	START "EXTRACTING ATTACHMENT BODIES"     /min /wait cmd /c Step2-Extract.bat Attachment.Body
	ECHO.
	ECHO EXTRACTING ATTACHMENT NAMES...
	ECHO EXTRACTING ATTACHMENT NAMES      >> log.txt
	START "EXTRACTING ATTACHMENT NAMES"      /min /wait cmd /c Step2-Extract.bat Attachment.Name
	ECHO.
	ECHO EXTRACTING ATTACHMENT PARENT IDS...
	ECHO EXTRACTING ATTACHMENT PARENT IDS >> log.txt
	START "EXTRACTING ATTACHMENT PARENT IDS" /min /wait cmd /c Step2-Extract.bat Attachment.ParentId

	ECHO.
	ECHO CREATING ATTACHMENT FILES...
	ECHO CREATING ATTACHMENT FILES        >> log.txt
	:: pop out to current directory
	POPD

	:: break ExportVersionData.csv into component files
	CALL cscript Step3a-ReadBody.vbs //nologo

	:: decrypt component files
	CALL Step4a-DecryptBody.bat

	::skip step 5 (not needed for attachments)

	::skip step 6 (not needed for attachments)

	:: rename component files
	CALL Step7a-RenameFile.bat
	ECHO.
	ECHO ATTACHMENT CREATION COMPLETE! RETURNING TO MAIN MENU
	GOTO menu
	
:content
	:: grab Salesforce data
	ECHO.
	ECHO EXTRACTING CONTENT VERSION DATA...
	ECHO EXTRACTING CONTENT VERSION DATA               >> log.txt
	START "EXTRACTING CONTENT VERSION DATA"               /min /wait cmd /c Step2-Extract.bat ContentVersion.VersionData
	ECHO.
	ECHO EXTRACTING CONTENT FILE TYPES...
	ECHO EXTRACTING CONTENT FILE TYPES                 >> log.txt
	START "EXTRACTING CONTENT FILE TYPES"                 /min /wait cmd /c Step2-Extract.bat ContentVersion.FileType
	ECHO.
	ECHO EXTRACTING CONTENT FIRST PUBLISH LOCATION IDS...
	ECHO EXTRACTING CONTENT FIRST PUBLISH LOCATION IDS >> log.txt
	START "EXTRACTING CONTENT FIRST PUBLISH LOCATION IDS" /min /wait cmd /c Step2-Extract.bat ContentVersion.FirstPublishLocationId
	ECHO.
	ECHO EXTRACTING CONTENT TITLES...
	ECHO EXTRACTING CONTENT TITLES                     >> log.txt
	START "EXTRACTING CONTENT TITLES"                     /min /wait cmd /c Step2-Extract.bat ContentVersion.Title

	ECHO.
	ECHO CREATING CONTENT FILES...
	ECHO CREATING CONTENT FILES                        >> log.txt
	:: pop out to current directory
	POPD

	:: break ExportVersionData.csv into component files
	CALL cscript Step3cv-ReadVersionData.vbs //nologo

	:: decrypt component files
	CALL Step4cv-DecryptVersionData.bat

	:: replace strings in ExportFileTypes.csv with file extensions
	CALL Step5cv-ReplaceFileType.bat

	:: add file extensions to component files
	CALL Step6cv-AddFileType.bat

	:: rename component files
	CALL Step7cv-RenameFile.bat
	ECHO.
	ECHO CONTENT CREATION COMPLETE! RETURNING TO MAIN MENU
	GOTO menu

:documents
	:: grab Salesforce data
	ECHO.
	ECHO EXTRACTING DOCUMENT BODIES...
	ECHO EXTRACTING DOCUMENT BODIES     >> log.txt
	START "EXTRACTING DOCUMENT BODIES"     /min /wait cmd /c Step2-Extract.bat Document.Body
	ECHO.
	ECHO EXTRACTING DOCUMENT FOLDER IDS...
	ECHO EXTRACTING DOCUMENT FOLDER IDS >> log.txt
	START "EXTRACTING DOCUMENT FOLDER IDS" /min /wait cmd /c Step2-Extract.bat Document.FolderId
	ECHO.
	ECHO EXTRACTING DOCUMENT NAMES...
	ECHO EXTRACTING DOCUMENT NAMES      >> log.txt
	START "EXTRACTING DOCUMENT NAMES"      /min /wait cmd /c Step2-Extract.bat Document.Name
	ECHO.
	ECHO EXTRACTING DOCUMENT TYPES...
	ECHO EXTRACTING DOCUMENT TYPES      >> log.txt
	START "EXTRACTING DOCUMENT TYPES"      /min /wait cmd /c Step2-Extract.bat Document.Type

	ECHO.
	ECHO CREATING DOCUMENT FILES...
	ECHO CREATING DOCUMENT FILES        >> log.txt
	:: pop out to current directory
	POPD

	:: break ExportVersionData.csv into component files
	CALL cscript Step3d-ReadBody.vbs //nologo

	:: decrypt component files
	CALL Step4d-DecryptBody.bat

	::skip step 5 (not needed for documents)

	:: add file extensions to component files
	CALL Step6d-AddType.bat

	:: rename component files
	CALL Step7d-RenameFile.bat
	ECHO.
	ECHO DOCUMENT CREATION COMPLETE! RETURNING TO MAIN MENU
	GOTO menu

:quit
	:: prompt for target folder
	ECHO - Where should the extracted files be placed? The default file location is
	ECHO   "%WorkDir%"
	SET /P WorkDir=- Set target file directory, without quotation marks (press enter for default): 

	:: move files to target folder
	ECHO.
	ECHO MOVING EXTRACTED FILES...
	ECHO MOVING EXTRACTED FILES                                         >> log.txt 2>&1
	MD "%WorkDir%\CSVs"                                                 >> log.txt 2>&1
	MOVE "CSVs\*.csv" "%WorkDir%\CSVs"                                  >> log.txt 2>&1
	MD "%WorkDir%\Exported Attachments"                                 >> log.txt 2>&1
	MOVE "Exported Attachments\00P*.*" "%WorkDir%\Exported Attachments" >> log.txt 2>&1
	MD "%WorkDir%\Exported Content"                                     >> log.txt 2>&1
	MOVE "Exported Content\068*.*" "%WorkDir%\Exported Content"         >> log.txt 2>&1
	MD "%WorkDir%\Exported Documents"                                   >> log.txt 2>&1
	MOVE "Exported Documents\015*.*" "%WorkDir%\Exported Documents"     >> log.txt 2>&1

	:: delete working files & folders
	ECHO.
	ECHO DELETING WORKING FILES...
	ECHO DELETING WORKING FILES       >> log.txt 2>&1
	RD "CSVs"                         >> log.txt 2>&1
	RD "Exported Attachments"         >> log.txt 2>&1
	RD "Exported Content"             >> log.txt 2>&1
	RD "Exported Documents"           >> log.txt 2>&1
	DEL config.properties             >> log.txt 2>&1
	DEL process-conf.xml              >> log.txt 2>&1
	IF %SaveLog%==y GOTO end
	DEL log.txt

:end